<!-- cSpell: ignore docsnapper -->
# Slint Documentation


## Prerequisites
- Rust
- Node.js
- pnpm


## 🚀 Project Structure
The documentation site is built with [Astro Starlight](https://starlight.astro.build/) and reuses its
project structure.

```
docs/
├── public/
├── src/
│   ├── assets/
│   ├── content/
│   │   ├── docs/
│   │   └── config.ts
│   └── env.d.ts
├── tests/
├── astro.config.mjs
├── package.json
├── tsconfig.json
└──
```

Starlight looks for `.md` or `.mdx` files in the `src/content/docs/` directory. Each file is exposed as a route based on its file name.

Images can be added to `src/assets/` and embedded in Markdown with a relative link. They will be optimized
for download size and also their width and height will be extracted so the framework can render them without
ugly content shifts.

Static assets, like favicons, can be placed in the `public/` directory. Note that images in this folder will
not be processed and optimized by Starlight.

## Building the docs

The docs use a lot of autogenerated content. First create all the screenshots which will be placed at `src/assets/generated/`.

```bash
cargo run -p slint-docsnapper -- docs/astro/src/content --overwrite
```

Then generate the slint auto generated content.

```bash
cargo xtask slintdocs
```

This xtask also installs the npm dependencies and builds the docs. The equivalent of:

```bash
pnpm i
pnpm run build
```

This will build the site and place it in `dist/`.

## Live edit the docs
To run the live hot reloading dev server run in the astro directory:

```bash
cd docs/astro/
pnpm start
```

This will start the dev server at [`localhost:4321/docs/`](http://localhost:4321/docs/).



## 🧞 Commands

All commands are run from the root of the project, from a terminal:

| Command                   | Action                                           |
| :------------------------ | :----------------------------------------------- |
| `pnpm i`                  | Installs dependencies                            |
| `pnpm start`              | Starts local dev server at `localhost:4321`      |
| `pnpm build`              | Build your production site to `./dist/`          |
| `pnpm preview`            | Preview your build locally, before deploying     |
| `pnpm run astro ...`      | Run CLI commands like `astro add`, `astro check` |
| `npm run astro -- --help` | Get help using the Astro CLI                     |



## 👀 Want to learn more about Astro and Starlight?

Check out [Starlight’s docs](https://starlight.astro.build/), read [the Astro documentation](https://docs.astro.build), or jump into the [Astro Discord server](https://astro.build/chat).
