
# Embedded Tutorial template


<!-- Copy and use as a basis -->

Start with an introduction to the tutorial. Include the following:

-   What will the reader learn by the end of it?
-   What hardware, and architecture combination is this tutorial designed for?

## Known limitations

Does this platform and architecture combination have any limitations, issues, etc?

## Prerequisites

-   What must a reader have available or installed to follow this tutorial?
    -   Slint language SDKs (seems obvious, but always worth providing people with a path back to earlier concepts)
        -   Are there any prerequisites for the language SDK for this hardware or architecture combination?
            -   For example can it only run versions up to a particular number, etc?
    -   The SDK for their board, etc
    -   Are any other dependencies needed for Slint to work on this setup?
        -   Windowing systems, headers, IDE plugins
        -   Slint supports Wayland, X-Windows, glibc, and d-bus
        -   Build systems
        -   Input and output drivers
-   What should they have ideally followed or understood before starting this tutorial?
    -   The quickstart, the introduction?
    -   Are there any external tutorials or resources specific to running Slint or a Slint-compatible language on the setup?

## Develop application

Suggest following the getting started tutorial. Note any special build steps required for the hardware, architecture, and software combination.

## Debugging techniques

Detail how people can test and debug an application running on another device.

## Conclusion and summary

- What did the reader learn in this tutorial and what should they read or do next?
- Does this platform and/or software combination require licensing? Then provide details on how to get in touch.
- Is there any other reason someone should get in touch with the Slint team about this platform and software combination? Then provide details on how to get in touch.
