
# Assets

## C++ SDK

For C++ developers, this release contains the following pre-packed builds of Slint:

| Desktop Operating System | Compiler | Architecture | Download |
|--------------------------|----------|--------------|----------|
| Linux                    | gcc      | x86-64       | [Slint-cpp-{version}-Linux-x86_64.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{version}-Linux-x86_64.tar.gz) |
| Linux                    | gcc      | arm64        | [Slint-cpp-{version}-Linux-arm64.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{version}-Linux-arm64.tar.gz) |
| Linux                    | gcc      | armhf        | [Slint-cpp-{version}-Linux-armhf.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{version}-Linux-armhf.tar.gz) |
| Windows                  | MSVC     | x86-64       | [Slint-cpp-{version}-win64-MSVC-AMD64.exe](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{version}-win64-MSVC-AMD64.exe) |
| Windows                  | MSVC     | arm64        | [Slint-cpp-{version}-win64-MSVC-ARM64.exe](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{version}-win64-MSVC-ARM64.exe) |

| Templates for Microcontroller Evaluation Board | Download |
|----------------------------------|----------|
| [STM32H747I-DISCO](https://www.st.com/en/evaluation-tools/stm32h747i-disco.html): Dual-core Arm M7/M4 MCU with 4” touch LCD display module | [slint-cpp-template-stm32h747i-disco.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-cpp-template-stm32h747i-disco.zip) |
| [STM32H735G-DK](https://www.st.com/en/evaluation-tools/stm32h735g-dk.html): Arm M7 MCU with 4” touch LCD display module | [slint-cpp-template-stm32h735g-dk.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-cpp-template-stm32h735g-dk.zip) |

## Tool Binaries

| Add-on    | Linux x86-64 | Windows (x86-64) | Windows (aarch64) | macOS (universal) | Linux aarch64 | Linux armv7 |
|-----------|--------------|---------|-------|-------|-------|-------|
| **slint-lsp** | [slint-lsp-linux.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-linux.tar.gz) | [slint-lsp-windows-x86_64.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-windows-x86_64.zip) | [slint-lsp-windows-arm64.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-windows-arm64.zip) | [slint-lsp-macos.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-macos.tar.gz) | [slint-lsp-aarch64-unknown-linux-gnu.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-aarch64-unknown-linux-gnu.tar.gz) | [slint-lsp-armv7-unknown-linux-gnueabihf.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-armv7-unknown-linux-gnueabihf.tar.gz)
| **slint-viewer** | [slint-viewer-linux.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-linux.tar.gz) | [slint-viewer-windows-x86_64.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-windows-x86_64.zip) | [slint-viewer-windows-arm64.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-windows-arm64.zip) | [slint-viewer-macos.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-macos.tar.gz) | [slint-viewer-aarch64-unknown-linux-gnu.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-aarch64-unknown-linux-gnu.tar.gz) | [slint-viewer-armv7-unknown-linux-gnueabihf.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-armv7-unknown-linux-gnueabihf.tar.gz)
