
# Embassy Slint stm32u5g9j-dk2 Demo

An embedded async Slint GUI demo using Embassy and an stm32u5g9j-dk2 development kit. This demo was written to run on a resource constrained device, not a PC or laptop.
The simulator can run on a PC if you do not have the dev kit on hand but it is not meant to be a reference design for an async GUI implementation on a PC.

The stm32u5g9j-dk2 was chosen because of its availability and price point and has enough onboard ram (3MB) and flash (4MB) to run Slint without external psram and flash, reducing setup complexity.
It comes with a 5" 800x480 IPS touchscreen display. Async is useful for building more complex UIs because you don't have to hand code your own state machines.

Things that are demonstrated here:
- Sending rendered display buffer to LCD screen asynchronously freeing up the mcu to do other things
- Responding to hardware events (pressing the USER button on the DK2 changes the colour of the grey circle to blue)
- Touchscreen actions setting physical hardware (toggling the switch on the touchscreen to turn on the green led on the DK2)
- Cooperative multitasking (red led continues to flash on a separate task regardless of UI actions)
- UI animations work
- The application can be simulated on a PC without having to download to the DK2 every time you want to test something

# Installation instructions

Install the cross compilation target for the mcu:

```bash
rustup target add thumbv8m.main-none-eabihf
```

You need software to be able to flash the firmware to the dev kit.

```bash
cargo install --force --locked probe-rs-tools
```

# Running the application

Plug a usbc cable into the ST-LINK port on the dk2 and run the following:

```bash
cargo run -p mcu-embassy --bin ui_mcu --release --features=mcu
```

Troubleshooting:

If you are getting some complication errors from cortex-m like  "error: invalid register `r1`: unknown register" make sure that you are cross compiling for the correct cpu target:

You can specify the target in the cargo run command in the following file:

In `.cargo/Cargo.toml`
```toml
[build]
target = "thumbv8m.main-none-eabihf"
```

If using vscode then make sure `rust-analyzer.cargo.features` is set to `mcu` in `.vscode/settings.json`

You may be wondering why you get the following message in the logs: `invalid location: defmt frame-index`
In the Slint workspace `Cargo.toml` file overrides the `Cargo.toml` file in this crate so make sure the release profile is as follows in that workspace file:
```toml
[profile.release]
debug = true    # required for decent panic messages and log line locations
opt-level = "s"
lto = "thin"
```

# Running the simulator

Of course you can use Slint's vscode plugin to preview slint files but you may want to actually run your application and simulate the hardware interactions.
The simulator runs Embassy on the host machine (instead of on an mcu) and renders to the screen using the sdl2 library.
Hardware like leds and buttons are emulated in the hardware module.

To install SDL2 follow the instructions here: https://github.com/Rust-SDL2/rust-sdl2

To run the simulator on a pc:
```bash
# for linux
cargo run -p mcu-embassy --bin ui_simulator --release --no-default-features --features=simulator --target x86_64-unknown-linux-gnu
# for windows
cargo run -p mcu-embassy --bin ui_simulator --release --no-default-features --features=simulator --target x86_64-pc-windows-msvc
# for mac
cargo run -p mcu-embassy --bin ui_simulator --release --no-default-features --features=simulator --target x86_64-apple-darwin
```

Note: Instead of specifying a target you can simply remove the arm target in .cargo/config.toml and cargo will use the host by default

Troubleshooting:

If you are getting some compilation errors from arrayvec like "error: requires `sized` lang_item" make sure you are NOT targeting the mcu when building for your pc.

Set the target correctly in the command line or comment out the following:

In `.cargo/Cargo.toml`
```toml
#[build]
#target = "thumbv8m.main-none-eabihf"
```

If using vscode then make sure `rust-analyzer.cargo.features` is set to `simulator` in `.vscode/settings.json`
