
**NOTE**: This library is an **internal** crate of the [Slint project](https://slint.dev).
This crate should **not be used directly** by applications using Slint.
You should use the `slint` crate instead.

**WARNING**: This crate does not follow the semver convention for versioning and can
only be used with `version = "=x.y.z"` in Cargo.toml.

# The Slint winit Backend

This crate implements the winit backend/platform for Slint.
It is enabled by default as a default feature of the `slint` crate.

Although this crate is primarily internal, it can also be used by applications
to leverage the full power of [`winit::window::Window`] for Slint Window.

To use this functionality, you need to be cautious when importing dependencies since
this crate does not adhere to semver and may introduce breaking changes in any patch release.
Additionally, the version of this crate must match the version of Slint.
To indicate that you specifically want this version, include the `=` symbol in the version string.

Make sure that the version of winit matches the version used by this crate.
Check this crate's dependencies to determine the required version.

```toml
[dependencies]
slint = { version = "x.y.z", ... }
i-slint-backend-winit = "=x.y.z"
winit = "0.w"
```

To ensure that the runtime backend is selected, initialize the backend as the first step in the `main` function:

```rust
fn main() {
    slint::platform::set_platform(Box::new(i_slint_backend_winit::Backend::new().unwrap()));
    // ...
}
```

Once you have a [`slint::Window`](i_slint_core::api::Window)
(accessible through the [window()](i_slint_core::api::ComponentHandle::window()) function of the generated component),
you can utilize the [`WinitWindowAccessor::with_winit_window`] function to access the [`winit::window::Window`] object.

```rust,no_run
# // similar to code generated by the slint! macro
# struct C; impl C { fn window(&self) ->i_slint_core::api::Window {todo!()} }
# let my_ui = C;
use i_slint_backend_winit::WinitWindowAccessor; // import the trait
my_ui.window().with_winit_window(|winit_window: &winit::window::Window| {
    // Here, you can use the winit API
});
```
